import os
""" Leitura, escrita e formatação de tempos do placar """
def ler_tempos(caminho: str) -> list[tuple[int, str]]:
    if not os.path.exists(caminho):
        return []
    resultados: list[tuple[int, str]] = []
    try:
        with open(caminho, "r", encoding="utf-8") as f:
            for linha in f:
                partes = linha.strip().split(";")
                if len(partes) == 2:
                    try:
                        ms = int(partes[0])
                        nome = partes[1]
                        resultados.append((ms, nome))
                    except ValueError:
                        pass
    except OSError:
        return []
    return resultados

def salvar_tempo(caminho: str, ms: int, nome: str) -> None:
    try:
        with open(caminho, "a", encoding="utf-8") as f:
            f.write(f"{ms};{nome}\n")
    except OSError:
        pass

def top5(registros: list[tuple[int, str]]) -> list[tuple[int, str]]:
    return sorted(registros, key=lambda x: x[0])[:5]

def formatar_ms(ms: int) -> str:
    s = ms // 1000
    ms_rem = ms % 1000
    return f"{s}.{ms_rem:03d}s"

     
    